// devquery.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

//standard include for a Microsoft Visual C++ project
#include "stdio.h"
//need for COM
#include "windows.h"
#include "comdef.h"
//This is the 'Automation' object (COM class). It contains the
// IIOManger interface
//below
const CLSID CLSID_INS001IOUtils =
{0x0D955199,0x6CB9,0x441C,{0xBA,0xA7,0x4A,0xC4,0xB9,0x8C,0x3C,0x47}};

//The IIO allows the opening of a device using its address in the 
// 'ConnectToInstrument' function. The IO class above exports this 
// COM interface.

//The IIO function 'ConnectToInstrument' will return the IIO interface
//this is an instance of the instrument.
const IID IID_IOUtils=
{0xD3327DF2,0xB390,0x4888,{0x8D,0x89,0xB8,0x1D,0xBD,0x8A,0x9D,0x7F}};

//The following are the definitions needed to program the instrument.
//They can be placed in a header file for but are shown here to allow
// ease of perusal
/***********************************************************************/
//This definition is to complete the IIO interface below. You needn't use 
// this interface directly to communicate with instruments
extern "C" {
	interface IIOUtils : IDispatch {
            STDMETHOD (Count)(short *pVal);
            STDMETHOD (TimeOut)(short *pVal);
			STDMETHOD (TimeOut)(short newVal);
			STDMETHOD (Open)(void);
			STDMETHOD (Close)(void);
			STDMETHOD (Refresh)(void);
		    STDMETHOD (Index)(short newVal);
			STDMETHOD (Index)(short &nNewValue);
			STDMETHOD (Output)(BSTR newVal);
			STDMETHOD (Input)(BSTR *pVal);
			STDMETHOD (Address)(BSTR *pVal);
			STDMETHOD (Query)(BSTR newValue, BSTR *pVal);
			STDMETHOD (Get_ErrFlag)(long *pVal);
			STDMETHOD (Connect)(BSTR newVal);
			};
}//extern "C"

int main(int argc, char* argv[])
{
	IIOUtils *IIO;   //The IO we'll be using to get to the instrument
	HRESULT hr;      //check return values for failure
	_variant_t myCmd;
	BSTR bstr;
	int dev_idx=0;
	short timeout=10000;
	short count;

	printf("\n ######  Start C++ Example program.  ######\n");
	printf("    We check the M3500A multimeter on USB port and\n");
	printf("    identify the first connected M3500A device.\n\n");

	//Initialize COM
	CoInitialize(NULL);

	//Create the INS001 IOUtils component
	hr =
		CoCreateInstance(CLSID_INS001IOUtils,NULL,CLSCTX_INPROC_SERVER,
		                 IID_IOUtils,(LPVOID *)&IIO);
	if FAILED(hr)
	{
		printf("CoCreateInstance failed\n");
		return 0;
	}

	IIO->Refresh();
	IIO->Count(&count);
    if (  count == 0 )
	{
		printf("\n M3500A USB connect failed (USB).\n");
		return 0;
	}

	// Assigned the first M3500A device (USB port) for command test
	IIO->Index(dev_idx);
	IIO->TimeOut(&timeout);

	// Write command "*IDN?" and read the M3500A identification string
	myCmd = "*IDN?";
	IIO->Output(_bstr_t(myCmd));
	IIO->Input(&bstr);
	printf("    output : *IDN?\n");
	printf("    input  : %s\n\n",(char *)_bstr_t(bstr));

	myCmd = "SAMP:COUN 1";
	IIO->Output(_bstr_t(myCmd));
    // Fetch the M3500A measure value ( screen value )

	// Set Voltage AC measure
	myCmd = "CONF:VOLT:AC 1,0.001";
	IIO->Output(_bstr_t(myCmd));
	myCmd = "READ?";
	IIO->Output(_bstr_t(myCmd));
	IIO->Input(&bstr);
	printf("    output : READ?\n");
	printf("    input  : %s\n\n",(char *)_bstr_t(bstr));

	// Set Voltage DC measure
	myCmd = "CONF:VOLT:DC 10,0.1";
	IIO->Output(_bstr_t(myCmd));
	myCmd = "READ?";
	IIO->Output(_bstr_t(myCmd));
	IIO->Input(&bstr);
	printf("    output : READ?\n");
	printf("    input  : %s\n\n",(char *)_bstr_t(bstr));

	IIO->Close();
	IIO->Release();
	//Uninit so COM is exited clean.
	CoUninitialize();

	return 0;
}
